//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F19 - External Forces
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

#include "mbs_project_interface.h"

void mbs_extforces(double **frc, double **trq,
MbsData *s, double tsim)
{
#include "mbs_extforces_pendulum_spring_c.h"

double PxF1[4] = {0}; 
double RxF1[4][4] = {{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}}; 
double VxF1[4] = {0}; 
double OMxF1[4] = {0}; 
double AxF1[4] = {0}; 
double OMPxF1[4] = {0}; 
double *SWr1; 

double *q, *qd, *qdd;
double **dpt, **l;

frc = s->frc;
trq = s->trq;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
l = s->l;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics

RLcp2_12 = dpt[3][5]*S1;
RLcp2_32 = dpt[3][5]*C1;
ORcp2_12 = qd[1]*RLcp2_32;
ORcp2_32 = -qd[1]*RLcp2_12;
ACcp2_12 = qd[1]*ORcp2_32+qdd[1]*RLcp2_32;
ACcp2_32 = -qd[1]*ORcp2_12-qdd[1]*RLcp2_12;
PxF1[1] = RLcp2_12;
PxF1[2] = 0;
PxF1[3] = RLcp2_32;
RxF1[1][1] = C1;
RxF1[1][3] = -S1;
RxF1[2][2] = (1.0);
RxF1[3][1] = S1;
RxF1[3][3] = C1;
VxF1[1] = ORcp2_12;
VxF1[2] = 0;
VxF1[3] = ORcp2_32;
OMxF1[1] = 0;
OMxF1[2] = qd[1];
OMxF1[3] = 0;
AxF1[1] = ACcp2_12;
AxF1[2] = 0;
AxF1[3] = ACcp2_32;
OMPxF1[1] = 0;
OMPxF1[2] = qdd[1];
OMPxF1[3] = 0;
 
// Sensor Forces 

SWr1 = user_call_ExtForces(PxF1,RxF1,VxF1,OMxF1,AxF1,OMPxF1,s,tsim,1);
xfrc12 = RxF1[1][1]*SWr1[1]+RxF1[1][3]*SWr1[3];
xfrc22 = RxF1[2][2]*SWr1[2];
xfrc32 = RxF1[3][1]*SWr1[1]+RxF1[3][3]*SWr1[3];
xtrq12 = RxF1[1][1]*SWr1[4]+RxF1[1][3]*SWr1[6];
xtrq22 = RxF1[2][2]*SWr1[5];
xtrq32 = RxF1[3][1]*SWr1[4]+RxF1[3][3]*SWr1[6];
trqext_1_1_1 = xtrq12-xfrc22*(SWr1[9]-l[3][1])+xfrc32*SWr1[8];
trqext_2_1_1 = xtrq22+xfrc12*(SWr1[9]-l[3][1])-xfrc32*SWr1[7];
trqext_3_1_1 = xtrq32-xfrc12*SWr1[8]+xfrc22*SWr1[7];
 
// Symbolic model output

frc[1][1] = frc[1][1]+xfrc12;
frc[2][1] = frc[2][1]+xfrc22;
frc[3][1] = frc[3][1]+xfrc32;
trq[1][1] = trq[1][1]+trqext_1_1_1;
trq[2][1] = trq[2][1]+trqext_2_1_1;
trq[3][1] = trq[3][1]+trqext_3_1_1;

// Number of continuation lines = 0

}
